/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.lavender.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.wispforest.lavender.Lavender;
import io.wispforest.lavender.book.Book;
import io.wispforest.lavender.book.Category;
import io.wispforest.lavender.book.Entry;
import io.wispforest.lavender.client.LavenderClient;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LavenderClientStorage {
    private static final TypeToken<Map<UUID, Map<class_2960, List<Bookmark>>>> BOOKMARKS_TYPE = new TypeToken<Map<UUID, Map<class_2960, List<Bookmark>>>>(){};
    private static Map<UUID, Map<class_2960, List<Bookmark>>> bookmarks;
    private static final TypeToken<Map<UUID, Set<class_2960>>> OPENED_BOOKS_TYPE;
    private static Map<UUID, Set<class_2960>> openedBooks;
    private static final Gson GSON;

    public static List<Bookmark> getBookmarks(Book book) {
        Map<class_2960, List<Bookmark>> worldBookmarks = bookmarks.get(LavenderClient.currentWorldId());
        if (worldBookmarks == null) {
            return List.of();
        }
        if (!worldBookmarks.containsKey(book.id())) {
            return List.of();
        }
        return worldBookmarks.get(book.id());
    }

    public static void addBookmark(Book book, Entry entry) {
        LavenderClientStorage.getBookmarkList(book).add(new Bookmark(Bookmark.Type.ENTRY, entry.id()));
        LavenderClientStorage.save();
    }

    public static void addBookmark(Book book, Category entry) {
        LavenderClientStorage.getBookmarkList(book).add(new Bookmark(Bookmark.Type.CATEGORY, entry.id()));
        LavenderClientStorage.save();
    }

    public static void removeBookmark(Book book, Bookmark bookmark) {
        LavenderClientStorage.getBookmarkList(book).remove(bookmark);
        LavenderClientStorage.save();
    }

    private static List<Bookmark> getBookmarkList(Book book) {
        return bookmarks.computeIfAbsent(LavenderClient.currentWorldId(), $ -> new HashMap()).computeIfAbsent(book.id(), $ -> new ArrayList());
    }

    public static boolean wasBookOpened(class_2960 book) {
        return LavenderClientStorage.getOpenedBooksSet().contains(book);
    }

    public static void markBookOpened(class_2960 book) {
        LavenderClientStorage.getOpenedBooksSet().add(book);
        LavenderClientStorage.save();
    }

    private static Set<class_2960> getOpenedBooksSet() {
        return openedBooks.computeIfAbsent(LavenderClient.currentWorldId(), $ -> new HashSet());
    }

    private static void save() {
        try {
            JsonObject data = new JsonObject();
            data.add("bookmarks", GSON.toJsonTree(bookmarks, BOOKMARKS_TYPE.getType()));
            data.add("opened_books", GSON.toJsonTree(openedBooks, OPENED_BOOKS_TYPE.getType()));
            Files.writeString(LavenderClientStorage.storageFile(), (CharSequence)GSON.toJson((JsonElement)data), new OpenOption[0]);
        }
        catch (IOException e) {
            Lavender.LOGGER.warn("Failed to save bookmarks", (Throwable)e);
        }
    }

    private static Path storageFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("lavender_client_storage.json");
    }

    static {
        OPENED_BOOKS_TYPE = new TypeToken<Map<UUID, Set<class_2960>>>(){};
        GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).setPrettyPrinting().create();
        try {
            JsonObject data = (JsonObject)GSON.fromJson(Files.readString(LavenderClientStorage.storageFile()), JsonObject.class);
            bookmarks = (Map)GSON.fromJson(data.get("bookmarks"), BOOKMARKS_TYPE);
            openedBooks = (Map)GSON.fromJson(data.get("opened_books"), OPENED_BOOKS_TYPE);
        }
        catch (Exception e) {
            bookmarks = new HashMap<UUID, Map<class_2960, List<Bookmark>>>();
            openedBooks = new HashMap<UUID, Set<class_2960>>();
            LavenderClientStorage.save();
        }
    }

    public record Bookmark(Type type, class_2960 id) {
        @Nullable
        public Book.BookmarkableElement tryResolve(Book book) {
            return switch (this.type) {
                default -> throw new IncompatibleClassChangeError();
                case Type.CATEGORY -> book.categoryById(this.id);
                case Type.ENTRY -> book.entryById(this.id);
            };
        }

        public static enum Type {
            ENTRY,
            CATEGORY;

        }
    }
}

